import { Routes, Route } from 'react-router-dom';
import { useEffect } from 'react';

import FBOHeader from '@/fbo/components/FBOHeader';
import FBOHero from '@/fbo/sections/FBOHero';
import FBOProducts from '@/fbo/sections/FBOProducts';
import FBOProductDetail from '@/fbo/pages/FBOProductDetail';
import FBOCart from '@/fbo/pages/FBOCart';
import FBOFooter from '@/fbo/components/FBOFooter';
import FBOFixedContact from '@/fbo/components/FBOFixedContact';

import { useFBOAdmin } from '@/context/FBOAdminContext';

export default function FBOSite() {
  const { theme } = useFBOAdmin();

  useEffect(() => {
    // Apply FBO theme colors as CSS variables
    const root = document.documentElement;
    root.style.setProperty('--fbo-primary', theme.primaryColor);
    root.style.setProperty('--fbo-secondary', theme.secondaryColor);
    root.style.setProperty('--fbo-accent', theme.accentColor);
    root.style.setProperty('--fbo-bg', theme.backgroundColor);
    root.style.setProperty('--fbo-text', theme.textColor);
    root.style.setProperty('--fbo-card', theme.cardBackground);
    
    // Add FBO theme class to body
    document.body.classList.add('fbo-theme');
    
    return () => {
      document.body.classList.remove('fbo-theme');
    };
  }, [theme]);

  return (
    <div 
      className="min-h-screen transition-colors duration-300"
      style={{ 
        backgroundColor: theme.backgroundColor,
        color: theme.textColor 
      }}
    >
      <FBOHeader />
      
      <Routes>
        <Route path="/" element={
          <main>
            <FBOHero />
            <FBOProducts />
          </main>
        } />
        <Route path="/products" element={
          <main className="pt-24">
            <FBOProducts showAll />
          </main>
        } />
        <Route path="/product/:id" element={
          <main className="pt-24">
            <FBOProductDetail />
          </main>
        } />
        <Route path="/cart" element={
          <main className="pt-24">
            <FBOCart />
          </main>
        } />
      </Routes>
      
      <FBOFooter />
      <FBOFixedContact />
    </div>
  );
}
