import { BrowserRouter as Router, Routes, Route } from 'react-router-dom';
import { useEffect, Suspense, lazy } from 'react';
import { I18nextProvider } from 'react-i18next';
import i18n from '@/i18n';

// Contexts
import { ContentProvider } from '@/context/ContentContext';
import { SectionsProvider } from '@/context/SectionsContext';
import { AuthProvider } from '@/context/AuthContext';
import { FBOAdminProvider } from '@/context/FBOAdminContext';

// Lazy load pages
const MainWebsite = lazy(() => import('@/pages/MainWebsite'));

// Loading component
function LoadingScreen() {
  return (
    <div className="min-h-screen bg-[#0a0a0a] flex items-center justify-center">
      <div className="flex flex-col items-center gap-4">
        <div className="w-12 h-12 border-4 border-red-600 border-t-transparent rounded-full animate-spin" />
        <p className="text-white/60 text-sm">Chargement...</p>
      </div>
    </div>
  );
}

function App() {
  useEffect(() => {
    const initGSAP = async () => {
      const gsap = (await import('gsap')).default;
      const { ScrollTrigger } = await import('gsap/ScrollTrigger');
      gsap.registerPlugin(ScrollTrigger);
    };
    initGSAP();
  }, []);

  return (
    <I18nextProvider i18n={i18n}>
      <ContentProvider>
        <SectionsProvider>
          <FBOAdminProvider>
            <AuthProvider>
              <Router>
                <Suspense fallback={<LoadingScreen />}>
                  <Routes>
                    <Route path="/*" element={<MainWebsite />} />
                  </Routes>
                </Suspense>
              </Router>
            </AuthProvider>
          </FBOAdminProvider>
        </SectionsProvider>
      </ContentProvider>
    </I18nextProvider>
  );
}

export default App;
