import { useEffect, useRef } from 'react';
import { ArrowRight } from 'lucide-react';
import gsap from 'gsap';
import { ScrollTrigger } from 'gsap/ScrollTrigger';

gsap.registerPlugin(ScrollTrigger);

interface ApproachProps {
  onNavigate?: (section: string) => void;
}

export default function Approach({ onNavigate }: ApproachProps) {
  const sectionRef = useRef<HTMLDivElement>(null);

  useEffect(() => {
    const ctx = gsap.context(() => {
      gsap.fromTo(
        '.approach-content',
        { y: 50, opacity: 0 },
        {
          y: 0,
          opacity: 1,
          duration: 0.8,
          scrollTrigger: {
            trigger: sectionRef.current,
            start: 'top 80%',
            toggleActions: 'play none none reverse',
          },
        }
      );
    }, sectionRef);

    return () => ctx.revert();
  }, []);

  return (
    <section ref={sectionRef} className="section-padding bg-[#0a0a0a] relative">
      <div className="container-custom">
        <div className="approach-content grid lg:grid-cols-2 gap-12 lg:gap-20">
          {/* Left - Main Approach */}
          <div>
            <div className="flex flex-wrap gap-x-4 gap-y-2 mb-6">
              <span className="text-2xl md:text-3xl font-bold text-white">CONSEIL</span>
              <span className="text-2xl md:text-3xl font-bold text-white">DÉPLOIEMENT</span>
              <span className="text-2xl md:text-3xl font-bold text-white">SUPPORT</span>
              <span className="text-2xl md:text-3xl font-bold gradient-text">MAÎTRISE</span>
              <span className="text-2xl md:text-3xl font-bold gradient-text">& AGILITÉ</span>
            </div>
            <p className="text-white/60 text-lg mb-8 max-w-lg">
              Nous accompagnons la transformation digitale avec une approche terrain : cartographie, priorisation, livraison incrémentale et adoption.
            </p>
            <button
              onClick={() => onNavigate?.('services')}
              className="btn-outline"
            >
              <span>Découvrir l'approche</span>
              <ArrowRight className="w-4 h-4" />
            </button>
          </div>

          {/* Right - Performance */}
          <div className="lg:text-right">
            <h3 className="text-2xl md:text-3xl font-bold text-white mb-4">
              PERFORMANCE <span className="gradient-text">& FIABILITÉ</span>
            </h3>
            <p className="text-white/60 text-lg mb-8 lg:ml-auto max-w-lg">
              Des solutions validées en environnement réel : haute disponibilité, sécurité et conformité.
            </p>
            <button
              onClick={() => onNavigate?.('projects')}
              className="btn-outline lg:ml-auto"
            >
              <span>Voir les référencements</span>
              <ArrowRight className="w-4 h-4" />
            </button>
          </div>
        </div>
      </div>
    </section>
  );
}
