import { useEffect, useRef } from 'react';
import { useTranslation } from 'react-i18next';
import gsap from 'gsap';
import { ScrollTrigger } from 'gsap/ScrollTrigger';

gsap.registerPlugin(ScrollTrigger);

const Performance = () => {
  const { t } = useTranslation();
  const sectionRef = useRef<HTMLElement>(null);

  useEffect(() => {
    const section = sectionRef.current;
    if (!section) return;

    const ctx = gsap.context(() => {
      gsap.from('.perf-bg', {
        scrollTrigger: {
          trigger: section,
          start: 'top 80%',
          toggleActions: 'play none none reverse',
        },
        scale: 1.1,
        opacity: 0,
        duration: 1,
        ease: 'power3.out',
      });

      gsap.from('.perf-content > *', {
        scrollTrigger: {
          trigger: section,
          start: 'top 60%',
          toggleActions: 'play none none reverse',
        },
        y: 40,
        opacity: 0,
        duration: 0.8,
        stagger: 0.15,
        ease: 'power3.out',
      });
    }, section);

    return () => ctx.revert();
  }, []);

  return (
    <section
      ref={sectionRef}
      className="min-h-[80vh] relative overflow-hidden py-24"
    >
      {/* Background Image */}
      <div className="perf-bg absolute inset-0 w-full h-full">
        <img
          src="/images/bg_city_tech.jpg"
          alt="City Tech"
          className="w-full h-full object-cover img-treated"
        />
        <div className="absolute inset-0 bg-zlo-dark/70" />
      </div>

      {/* Content */}
      <div className="perf-content relative w-full h-full flex flex-col items-center justify-center text-center px-6 min-h-[60vh]">
        <h2 className="heading-xl gradient-text mb-6">
          {t('performance.title')}
        </h2>
        <div className="gradient-line w-[60%] max-w-[500px] mb-8" />
        <p className="body-text text-zlo-text-secondary max-w-3xl mb-10">
          {t('performance.subtitle')}
        </p>
        <button className="cta-button-orange">
          {t('performance.cta')}
        </button>
      </div>
    </section>
  );
};

export default Performance;