import { ArrowUp } from 'lucide-react';

export default function Footer() {
  const scrollToTop = () => {
    window.scrollTo({ top: 0, behavior: 'smooth' });
  };

  const currentYear = new Date().getFullYear();

  const quickLinks = [
    { label: 'Accueil', href: '#hero' },
    { label: 'À propos', href: '#about' },
    { label: 'Services', href: '#services' },
    { label: 'Projets', href: '#projects' },
    { label: 'La Team', href: '#team' },
    { label: 'Contact', href: '#contact' },
  ];

  const services = [
    { label: 'Dématérialisation & GED', href: '#services' },
    { label: 'E-Procurement', href: '#services' },
    { label: 'Développement sur mesure', href: '#services' },
    { label: 'Géolocalisation & IoT', href: '#services' },
  ];

  return (
    <footer className="bg-[#050505] border-t border-white/5">
      <div className="container-custom py-16">
        <div className="grid md:grid-cols-2 lg:grid-cols-4 gap-12 mb-12">
          {/* Company Info */}
          <div className="lg:col-span-1">
            <a href="#hero" className="flex items-center gap-0 mb-6">
              <span className="text-xl font-bold text-white tracking-tight">ZLO</span>
              <span className="text-xl font-bold text-orange-500 tracking-tight">Technologies</span>
            </a>
            <p className="text-white/50 text-sm leading-relaxed">
              ZLO Technologies est une société de services en ingénierie informatique (SSII) qui se spécialise dans le développement et la fourniture de solutions technologiques innovantes.
            </p>
          </div>

          {/* Quick Links */}
          <div>
            <h4 className="text-white font-semibold mb-6">Liens rapides</h4>
            <ul className="space-y-3">
              {quickLinks.map((link, index) => (
                <li key={index}>
                  <a
                    href={link.href}
                    className="text-white/50 hover:text-white text-sm transition-colors"
                  >
                    {link.label}
                  </a>
                </li>
              ))}
            </ul>
          </div>

          {/* Services */}
          <div>
            <h4 className="text-white font-semibold mb-6">Services</h4>
            <ul className="space-y-3">
              {services.map((service, index) => (
                <li key={index}>
                  <a
                    href={service.href}
                    className="text-white/50 hover:text-white text-sm transition-colors"
                  >
                    {service.label}
                  </a>
                </li>
              ))}
            </ul>
          </div>

          {/* Contact */}
          <div>
            <h4 className="text-white font-semibold mb-6">Contact</h4>
            <ul className="space-y-3">
              <li>
                <a
                  href="mailto:contact@zlotech.net"
                  className="text-white/50 hover:text-white text-sm transition-colors"
                >
                  contact@zlotech.net
                </a>
              </li>
              <li>
                <a
                  href="tel:+22892605949"
                  className="text-white/50 hover:text-white text-sm transition-colors"
                >
                  +228 92 60 59 49
                </a>
              </li>
              <li className="text-white/50 text-sm">
                Lomé, Togo — CEDEAO
              </li>
              <li className="text-white/50 text-sm">
                Lun – Ven: 8h–18h (GMT)
              </li>
            </ul>
          </div>
        </div>

        {/* Bottom Bar */}
        <div className="pt-8 border-t border-white/5 flex flex-col sm:flex-row items-center justify-between gap-4">
          <p className="text-white/30 text-sm">
            © {currentYear} ZLO Technologies — Conçu pour durer.
          </p>
          <div className="flex items-center gap-6">
            <a href="#" className="text-white/30 hover:text-white text-sm transition-colors">
              Mentions légales
            </a>
            <a href="#" className="text-white/30 hover:text-white text-sm transition-colors">
              Politique de confidentialité
            </a>
          </div>
          <button
            onClick={scrollToTop}
            className="w-10 h-10 bg-gradient-to-r from-red-600 to-orange-500 rounded-lg flex items-center justify-center text-white hover:shadow-lg hover:shadow-red-500/30 transition-all hover:scale-110"
          >
            <ArrowUp className="w-5 h-5" />
          </button>
        </div>
      </div>
    </footer>
  );
}
