import { StrictMode } from 'react';
import { createRoot } from 'react-dom/client';
import { BrowserRouter as Router, Routes, Route } from 'react-router-dom';
import { I18nextProvider } from 'react-i18next';
import i18n from '@/i18n';

// Contexts
import { CurrencyProvider } from '@/context/CurrencyContext';
import { FBOAdminProvider } from '@/context/FBOAdminContext';

// Pages
import FBOSite from '@/pages/FBOSite';

// Styles
import '@/index.css';

// FBO App component
function FBOApp() {
  return (
    <I18nextProvider i18n={i18n}>
      <FBOAdminProvider>
        <CurrencyProvider>
          <Router>
            <Routes>
              <Route path="/*" element={<FBOSite />} />
            </Routes>
          </Router>
        </CurrencyProvider>
      </FBOAdminProvider>
    </I18nextProvider>
  );
}

// Render
const rootElement = document.getElementById('root');
if (rootElement) {
  createRoot(rootElement).render(
    <StrictMode>
      <FBOApp />
    </StrictMode>
  );
}
