import { Link } from 'react-router-dom';
import { Leaf, Phone, Mail, MapPin, Facebook, Instagram } from 'lucide-react';
import { useFBOAdmin } from '@/context/FBOAdminContext';

export default function FBOFooter() {
  const { contact, theme } = useFBOAdmin();

  const currentYear = new Date().getFullYear();

  return (
    <footer 
      className="py-12 border-t"
      style={{ 
        backgroundColor: theme.backgroundColor,
        borderColor: `${theme.textColor}10`
      }}
    >
      <div className="container mx-auto px-4 sm:px-6 lg:px-8">
        <div className="grid sm:grid-cols-2 lg:grid-cols-4 gap-8">
          {/* Brand */}
          <div>
            <Link to="/fbo" className="flex items-center gap-2 mb-4">
              <div 
                className="w-10 h-10 rounded-lg flex items-center justify-center"
                style={{ backgroundColor: theme.primaryColor }}
              >
                <Leaf className="w-6 h-6 text-white" />
              </div>
              <div>
                <span 
                  className="font-bold text-lg block"
                  style={{ color: theme.primaryColor }}
                >
                  Forever Living
                </span>
                <span 
                  className="text-xs"
                  style={{ color: `${theme.textColor}60` }}
                >
                  Products - ZLO FBO
                </span>
              </div>
            </Link>
            <p 
              className="text-sm"
              style={{ color: `${theme.textColor}70` }}
            >
              Votre distributeur officiel Forever Living Products au Sénégal. 
              Des produits naturels à base d'aloe vera pour votre bien-être.
            </p>
          </div>

          {/* Quick Links */}
          <div>
            <h4 
              className="font-semibold mb-4"
              style={{ color: theme.textColor }}
            >
              Liens rapides
            </h4>
            <ul className="space-y-2">
              <li>
                <Link 
                  to="/fbo" 
                  className="text-sm hover:underline"
                  style={{ color: `${theme.textColor}70` }}
                >
                  Accueil
                </Link>
              </li>
              <li>
                <Link 
                  to="/fbo/products" 
                  className="text-sm hover:underline"
                  style={{ color: `${theme.textColor}70` }}
                >
                  Nos produits
                </Link>
              </li>
              <li>
                <a 
                  href="/" 
                  className="text-sm hover:underline"
                  style={{ color: `${theme.textColor}70` }}
                >
                  ZLO Technologies
                </a>
              </li>
            </ul>
          </div>

          {/* Contact */}
          <div>
            <h4 
              className="font-semibold mb-4"
              style={{ color: theme.textColor }}
            >
              Contact
            </h4>
            <ul className="space-y-3">
              <li className="flex items-center gap-2">
                <Phone className="w-4 h-4" style={{ color: theme.primaryColor }} />
                <a 
                  href={`tel:${contact.phone}`}
                  className="text-sm hover:underline"
                  style={{ color: `${theme.textColor}70` }}
                >
                  {contact.phone}
                </a>
              </li>
              <li className="flex items-center gap-2">
                <Mail className="w-4 h-4" style={{ color: theme.primaryColor }} />
                <a 
                  href={`mailto:${contact.email}`}
                  className="text-sm hover:underline"
                  style={{ color: `${theme.textColor}70` }}
                >
                  {contact.email}
                </a>
              </li>
              <li className="flex items-start gap-2">
                <MapPin className="w-4 h-4 mt-0.5" style={{ color: theme.primaryColor }} />
                <span 
                  className="text-sm"
                  style={{ color: `${theme.textColor}70` }}
                >
                  {contact.address}
                </span>
              </li>
            </ul>
          </div>

          {/* Social */}
          <div>
            <h4 
              className="font-semibold mb-4"
              style={{ color: theme.textColor }}
            >
              Suivez-nous
            </h4>
            <div className="flex gap-3">
              <a
                href="#"
                className="w-10 h-10 rounded-full flex items-center justify-center transition-colors"
                style={{ 
                  backgroundColor: `${theme.primaryColor}15`,
                  color: theme.primaryColor 
                }}
              >
                <Facebook className="w-5 h-5" />
              </a>
              <a
                href="#"
                className="w-10 h-10 rounded-full flex items-center justify-center transition-colors"
                style={{ 
                  backgroundColor: `${theme.primaryColor}15`,
                  color: theme.primaryColor 
                }}
              >
                <Instagram className="w-5 h-5" />
              </a>
            </div>
          </div>
        </div>

        {/* Bottom */}
        <div 
          className="mt-12 pt-8 border-t text-center"
          style={{ borderColor: `${theme.textColor}10` }}
        >
          <p 
            className="text-sm"
            style={{ color: `${theme.textColor}50` }}
          >
            © {currentYear} ZLO Technologies - FBO Forever Living Products. 
            Tous droits réservés.
          </p>
        </div>
      </div>
    </footer>
  );
}
