import { useEffect, useRef } from 'react';
import { useTranslation } from 'react-i18next';
import gsap from 'gsap';
import { ScrollTrigger } from 'gsap/ScrollTrigger';

gsap.registerPlugin(ScrollTrigger);

const Security = () => {
  const { t } = useTranslation();
  const sectionRef = useRef<HTMLElement>(null);

  useEffect(() => {
    const section = sectionRef.current;
    if (!section) return;

    const ctx = gsap.context(() => {
      gsap.from('.sec-bg', {
        scrollTrigger: {
          trigger: section,
          start: 'top 80%',
          toggleActions: 'play none none reverse',
        },
        scale: 1.1,
        opacity: 0,
        duration: 1,
        ease: 'power3.out',
      });

      gsap.from('.sec-text > *', {
        scrollTrigger: {
          trigger: section,
          start: 'top 60%',
          toggleActions: 'play none none reverse',
        },
        x: -40,
        opacity: 0,
        duration: 0.8,
        stagger: 0.15,
        ease: 'power3.out',
      });
    }, section);

    return () => ctx.revert();
  }, []);

  return (
    <section
      ref={sectionRef}
      className="min-h-[80vh] relative overflow-hidden py-24"
    >
      {/* Background Image */}
      <div className="sec-bg absolute inset-0 w-full h-full">
        <img
          src="/images/bg_server_room_wide.jpg"
          alt="Server Room"
          className="w-full h-full object-cover img-treated"
        />
        <div className="absolute inset-0 bg-zlo-dark/70" />
      </div>

      {/* Content - Left Aligned */}
      <div className="sec-text relative w-full h-full flex flex-col justify-center px-6 lg:px-12 min-h-[60vh]">
        <div className="max-w-xl">
          <h2 className="heading-lg text-white mb-2">
            {t('security.title1')}
          </h2>
          <h2 className="heading-lg gradient-text mb-8">
            {t('security.title2')}
          </h2>
          <div className="gradient-line w-[50%] max-w-[300px] mb-8" />
          <p className="body-text text-zlo-text-secondary mb-10">
            {t('security.body')}
          </p>
          <button className="cta-button-gradient">
            {t('security.cta')}
          </button>
        </div>
      </div>
    </section>
  );
};

export default Security;