import { Routes, Route, Navigate, useNavigate } from 'react-router-dom';
import { useEffect } from 'react';
import { useAuth } from '@/context/AuthContext';

import AdminSidebar from '@/admin/components/AdminSidebar';
import AdminHeader from '@/admin/components/AdminHeader';
import Dashboard from '@/admin/components/Dashboard';
import ContentEditor from '@/admin/components/ContentEditor';
import SectionsManager from '@/admin/components/SectionsManager';
import FBOEditor from '@/admin/editors/FBOEditor';
import ThemeSettings from '@/admin/components/ThemeSettings';

export default function AdminPanel() {
  const { isAuthenticated } = useAuth();
  const navigate = useNavigate();

  useEffect(() => {
    if (!isAuthenticated) {
      navigate('/admin/login');
    }
  }, [isAuthenticated, navigate]);

  if (!isAuthenticated) {
    return null;
  }

  return (
    <div className="min-h-screen bg-[#0a0a0f] flex">
      <AdminSidebar />
      
      <div className="flex-1 flex flex-col ml-64">
        <AdminHeader />
        
        <main className="flex-1 p-6 overflow-auto">
          <Routes>
            <Route path="/dashboard" element={<Dashboard />} />
            <Route path="/content" element={<ContentEditor />} />
            <Route path="/sections" element={<SectionsManager />} />
            <Route path="/fbo/*" element={<FBOEditor />} />
            <Route path="/settings" element={<ThemeSettings />} />
            <Route path="/" element={<Navigate to="/admin/dashboard" replace />} />
          </Routes>
        </main>
      </div>
    </div>
  );
}
