import { useEffect, useRef } from 'react';
import { useTranslation } from 'react-i18next';
import gsap from 'gsap';
import { ScrollTrigger } from 'gsap/ScrollTrigger';

gsap.registerPlugin(ScrollTrigger);

const Process = () => {
  const { t } = useTranslation();
  const sectionRef = useRef<HTMLElement>(null);

  useEffect(() => {
    const section = sectionRef.current;
    if (!section) return;

    const ctx = gsap.context(() => {
      gsap.from('.proc-pill', {
        scrollTrigger: {
          trigger: section,
          start: 'top 70%',
          toggleActions: 'play none none reverse',
        },
        x: -60,
        opacity: 0,
        duration: 0.8,
        stagger: 0.15,
        ease: 'power3.out',
      });

      gsap.from('.proc-text', {
        scrollTrigger: {
          trigger: section,
          start: 'top 60%',
          toggleActions: 'play none none reverse',
        },
        x: 40,
        opacity: 0,
        duration: 0.8,
        stagger: 0.1,
        ease: 'power3.out',
      });
    }, section);

    return () => ctx.revert();
  }, []);

  return (
    <section
      ref={sectionRef}
      className="min-h-screen bg-zlo-dark grid-lines relative overflow-hidden py-24"
    >
      <div className="relative w-full px-6 lg:px-12">
        <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center min-h-[80vh]">
          {/* Left - Pills */}
          <div className="space-y-4">
            <div className="proc-pill w-full aspect-[16/10] pill-frame">
              <div className="relative w-full h-full">
                <img
                  src="/images/process_meeting.jpg"
                  alt="Process Meeting"
                  className="w-full h-full object-cover img-treated"
                />
                <div className="absolute inset-0 bg-gradient-to-t from-zlo-dark/60 to-transparent" />
              </div>
            </div>
            <div className="proc-pill w-[80%] aspect-[16/9] pill-frame">
              <div className="relative w-full h-full">
                <img
                  src="/images/process_presentation.jpg"
                  alt="Process Presentation"
                  className="w-full h-full object-cover img-treated"
                />
                <div className="absolute inset-0 bg-gradient-to-t from-zlo-dark/60 to-transparent" />
              </div>
            </div>
          </div>

          {/* Right - Text Block */}
          <div className="lg:pl-12">
            <h2 className="proc-text heading-lg text-white mb-2">
              {t('process.title1')}
            </h2>
            <h2 className="proc-text heading-lg gradient-text mb-8">
              {t('process.title2')}
            </h2>
            <div className="proc-text gradient-line w-[50%] max-w-[250px] mb-8" />
            <p className="proc-text body-text text-zlo-text-secondary mb-8">
              {t('process.body')}
            </p>
            <button className="proc-text cta-button-outline">
              {t('process.cta')}
            </button>
          </div>
        </div>
      </div>
    </section>
  );
};

export default Process;