# ZLO Platform

[![Version](https://img.shields.io/badge/version-1.0.0-blue.svg)](https://zlotech.net)
[![PHP](https://img.shields.io/badge/PHP-8.0+-777BB4.svg)](https://php.net)
[![MySQL](https://img.shields.io/badge/MySQL-8.0+-4479A1.svg)](https://mysql.com)
[![License](https://img.shields.io/badge/license-Proprietary-red.svg)](LICENSE)

> **Digital Innovation for Africa** - Enterprise-grade SaaS platform for fleet tracking, e-commerce, and AI automation.

## 🚀 Overview

ZLO Platform is a comprehensive technology solution designed for African enterprises. Built with modern SaaS architecture, it delivers scalable, secure, and high-performance digital solutions.

### Key Features

- 🚗 **Fleet Intelligence Platform** - Real-time GPS tracking and fleet optimization
- 🛒 **Smart Commerce Platform** - Complete e-commerce with mobile payments
- 🚌 **School Mobility Platform** - Intelligent school transport management
- 🤖 **AI Automation** - Business process automation with artificial intelligence

## 📋 Requirements

- **PHP** >= 8.0
- **MySQL** >= 8.0
- **Apache** >= 2.4 with mod_rewrite
- **Extensions**: PDO, PDO_MySQL, JSON, MBString, GD/Imagick

## ⚡ Quick Start

### 1. Clone the Repository

```bash
git clone https://github.com/zlotechy/Monsite.git
cd Monsite
```

### 2. Database Setup

```bash
# Create database
mysql -u root -p -e "CREATE DATABASE zlo_platform CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;"

# Import schema
mysql -u root -p zlo_platform < database/schema.sql
```

### 3. Environment Configuration

Create a `.env` file in the root directory:

```env
# Application
APP_ENV=production
APP_URL=https://zlotech.net
APP_DEBUG=false

# Database
DB_HOST=localhost
DB_PORT=3306
DB_NAME=zlo_platform
DB_USER=your_db_user
DB_PASSWORD=your_db_password

# Security
JWT_SECRET=your-super-secret-jwt-key-change-this

# Email (optional)
MAIL_DRIVER=smtp
MAIL_HOST=smtp.gmail.com
MAIL_PORT=587
MAIL_USERNAME=your-email@gmail.com
MAIL_PASSWORD=your-app-password
```

### 4. Permissions

```bash
# Set proper permissions
chmod -R 755 uploads/
chmod -R 755 logs/
chmod 644 .htaccess
```

### 5. Default Admin Access

- **Email**: `admin@zlotech.net`
- **Password**: `admin123`

⚠️ **Change the default password immediately after first login!**

## 📁 Project Structure

```
zlo-platform/
├── api/                    # Backend API (PHP 8+)
│   ├── config/            # Configuration files
│   ├── controllers/       # API controllers
│   ├── core/              # Core classes (Router, Security, Model)
│   ├── models/            # Database models
│   └── index.php          # API entry point
├── database/              # Database schema and migrations
│   └── schema.sql         # Complete database structure
├── public/                # Frontend assets
│   ├── assets/            # CSS, JS, images
│   └── index.html         # Main entry point
├── uploads/               # User uploads (images, documents)
├── logs/                  # Application logs
├── .htaccess              # Apache configuration
└── README.md              # This file
```

## 🔐 Security Features

- ✅ **JWT Authentication** - Stateless token-based auth
- ✅ **CSRF Protection** - Cross-site request forgery prevention
- ✅ **XSS Protection** - Input sanitization and output encoding
- ✅ **SQL Injection Prevention** - PDO prepared statements
- ✅ **Rate Limiting** - Brute force protection
- ✅ **Secure Headers** - X-Frame-Options, CSP, etc.
- ✅ **Password Hashing** - Bcrypt with cost factor 12

## 🛠️ API Endpoints

### Authentication

| Method | Endpoint | Description |
|--------|----------|-------------|
| POST | `/api/auth/login` | User login |
| POST | `/api/auth/logout` | User logout |
| POST | `/api/auth/refresh` | Refresh access token |
| GET | `/api/me` | Get current user |

### Solutions

| Method | Endpoint | Description |
|--------|----------|-------------|
| GET | `/api/solutions` | List all solutions |
| GET | `/api/solutions/featured` | Get featured solutions |
| GET | `/api/solutions/{id}` | Get solution by ID |
| GET | `/api/solutions/slug/{slug}` | Get solution by slug |
| POST | `/api/solutions` | Create solution (admin) |
| PUT | `/api/solutions/{id}` | Update solution (admin) |
| DELETE | `/api/solutions/{id}` | Delete solution (admin) |

## 🎨 Frontend

The frontend is built with:
- **Bootstrap 5** - Responsive grid and components
- **AOS** - Scroll animations
- **Vanilla JavaScript** - No framework dependencies
- **Bootstrap Icons** - Icon library

## 🚀 Deployment

### Shared Hosting (cPanel)

1. Upload files to `public_html/`
2. Create MySQL database in cPanel
3. Import `database/schema.sql`
4. Update `api/config/config.php` with your credentials
5. Set permissions for `uploads/` folder

### VPS/Dedicated Server

```bash
# Install dependencies
sudo apt update
sudo apt install apache2 mysql-server php8.1 php8.1-mysql php8.1-gd

# Enable mod_rewrite
sudo a2enmod rewrite
sudo a2enmod headers
sudo a2enmod deflate
sudo a2enmod expires

# Configure Apache
sudo nano /etc/apache2/sites-available/zlotech.conf
```

Apache configuration:

```apache
<VirtualHost *:80>
    ServerName zlotech.net
    DocumentRoot /var/www/zlo-platform
    
    <Directory /var/www/zlo-platform>
        Options -Indexes +FollowSymLinks
        AllowOverride All
        Require all granted
    </Directory>
    
    ErrorLog ${APACHE_LOG_DIR}/zlo-error.log
    CustomLog ${APACHE_LOG_DIR}/zlo-access.log combined
</VirtualHost>
```

```bash
sudo a2ensite zlotech
sudo systemctl restart apache2
```

### Docker (Optional)

```bash
# Build and run with Docker Compose
docker-compose up -d
```

## 📊 Database Schema

The database includes tables for:

- **Users & Roles** - Multi-role authentication system
- **Solutions** - Product catalog with features
- **Leads & CRM** - Customer relationship management
- **Blog** - Content management system
- **Analytics** - Visitor tracking
- **Settings** - Site configuration

See `database/schema.sql` for complete structure.

## 🧪 Testing

```bash
# Test API health
curl https://your-domain.com/api/health

# Test authentication
curl -X POST https://your-domain.com/api/auth/login \
  -H "Content-Type: application/json" \
  -d '{"email":"admin@zlotech.net","password":"admin123"}'
```

## 📈 Performance Optimization

- ✅ Gzip compression enabled
- ✅ Browser caching configured
- ✅ Image optimization
- ✅ Minified assets
- ✅ CDN-ready structure

## 🐛 Troubleshooting

### 404 Errors on API

Check `.htaccess` is present and mod_rewrite is enabled:

```bash
sudo a2enmod rewrite
sudo service apache2 restart
```

### Database Connection Failed

Verify credentials in `api/config/config.php`:

```php
'database' => [
    'host' => 'localhost',
    'name' => 'zlo_platform',
    'user' => 'your_user',
    'password' => 'your_password',
]
```

### Permission Denied on Uploads

```bash
chmod -R 755 uploads/
chown -R www-data:www-data uploads/
```

## 📝 Changelog

### v1.0.0 (2024-01-15)

- Initial release
- Fleet Intelligence Platform
- Smart Commerce Platform
- School Mobility Platform
- AI Automation Platform
- Admin Dashboard
- API v1

## 🤝 Support

- 📧 Email: support@zlotech.net
- 🌐 Website: https://zlotech.net
- 📞 Phone: +228 92 60 59 49

## 📄 License

This project is proprietary software. All rights reserved.

Copyright © 2024 ZLO Technologies

---

<p align="center">
  <strong>Built with ❤️ in Lomé, Togo</strong>
</p>
