<?php
/**
 * ZLO Platform - Configuration
 * SaaS-level configuration management
 */

declare(strict_types=1);

// Environment detection
$environment = $_ENV['APP_ENV'] ?? 'development';

// Base configuration
return [
    // Application
    'app' => [
        'name' => 'ZLO Technologies',
        'version' => '1.0.0',
        'env' => $environment,
        'debug' => $environment === 'development',
        'url' => $_ENV['APP_URL'] ?? 'https://zlotech.net',
        'timezone' => 'Africa/Lome',
        'locale' => 'fr',
        'fallback_locale' => 'en',
    ],
    
    // Database
    'database' => [
        'host' => $_ENV['DB_HOST'] ?? 'localhost',
        'port' => $_ENV['DB_PORT'] ?? '3306',
        'name' => $_ENV['DB_NAME'] ?? 'zlo_platform',
        'user' => $_ENV['DB_USER'] ?? 'root',
        'password' => $_ENV['DB_PASSWORD'] ?? '',
        'charset' => 'utf8mb4',
        'collation' => 'utf8mb4_unicode_ci',
        'options' => [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_EMULATE_PREPARES => false,
        ],
    ],
    
    // Security
    'security' => [
        'session_name' => 'zlo_session',
        'session_lifetime' => 7200, // 2 hours
        'csrf_token_name' => 'csrf_token',
        'password_cost' => 12,
        'max_login_attempts' => 5,
        'lockout_duration' => 900, // 15 minutes
        'allowed_origins' => [
            'https://zlotech.net',
            'https://admin.zlotech.net',
        ],
    ],
    
    // Uploads
    'uploads' => [
        'path' => __DIR__ . '/../../uploads/',
        'url_path' => '/uploads/',
        'max_size' => 10 * 1024 * 1024, // 10MB
        'allowed_types' => [
            'image' => ['jpg', 'jpeg', 'png', 'gif', 'webp', 'svg'],
            'document' => ['pdf', 'doc', 'docx', 'xls', 'xlsx', 'ppt', 'pptx'],
            'video' => ['mp4', 'webm', 'ogg'],
        ],
        'image_sizes' => [
            'thumbnail' => [150, 150],
            'medium' => [600, 400],
            'large' => [1200, 800],
        ],
    ],
    
    // Email
    'mail' => [
        'driver' => $_ENV['MAIL_DRIVER'] ?? 'smtp',
        'host' => $_ENV['MAIL_HOST'] ?? 'smtp.gmail.com',
        'port' => $_ENV['MAIL_PORT'] ?? 587,
        'username' => $_ENV['MAIL_USERNAME'] ?? '',
        'password' => $_ENV['MAIL_PASSWORD'] ?? '',
        'encryption' => $_ENV['MAIL_ENCRYPTION'] ?? 'tls',
        'from' => [
            'address' => $_ENV['MAIL_FROM_ADDRESS'] ?? 'noreply@zlotech.net',
            'name' => $_ENV['MAIL_FROM_NAME'] ?? 'ZLO Technologies',
        ],
    ],
    
    // API
    'api' => [
        'version' => 'v1',
        'rate_limit' => 100, // requests per minute
        'pagination_limit' => 20,
        'max_pagination_limit' => 100,
    ],
    
    // Cache
    'cache' => [
        'driver' => $environment === 'production' ? 'redis' : 'file',
        'ttl' => 3600, // 1 hour
    ],
    
    // Analytics
    'analytics' => [
        'enabled' => true,
        'track_ips' => true,
        'exclude_ips' => ['127.0.0.1', '::1'],
    ],
];
