import { useEffect } from 'react';
import { useTranslation } from 'react-i18next';
import { ArrowLeft, Scale } from 'lucide-react';

const LegalPage = () => {
  const { i18n } = useTranslation();

  useEffect(() => {
    window.scrollTo(0, 0);
  }, []);

  const goBack = () => {
    window.history.back();
  };

  const content = i18n.language === 'fr' ? {
    title: 'Mentions Légales',
    lastUpdate: 'Dernière mise à jour : Février 2026',
    sections: [
      {
        title: '1. Éditeur du site',
        content: `
          <p><strong>ZLO Technologies</strong></p>
          <p>Société de Services en Ingénierie Informatique (SSII)</p>
          <p>Siège social : Lomé, Togo</p>
          <p>Email : contact@zlotech.net</p>
          <p>Téléphone : +228 90 XX XX XX</p>
        `
      },
      {
        title: '2. Directeur de la publication',
        content: `
          <p><strong>G. Fambe O'Sodo</strong></p>
          <p>Managing Director - ZLO Technologies</p>
        `
      },
      {
        title: '3. Hébergement',
        content: `
          <p>Le site est hébergé par :</p>
          <p><strong>Kimi Deploy</strong></p>
          <p>Service de déploiement cloud</p>
        `
      },
      {
        title: '4. Propriété intellectuelle',
        content: `
          <p>L'ensemble du contenu de ce site (textes, images, vidéos, logos, etc.) est la propriété exclusive de ZLO Technologies ou de ses partenaires. Toute reproduction, représentation, modification, publication, transmission, dénaturation, totale ou partielle du site ou de son contenu, par quelque procédé que ce soit, et sur quelque support que ce soit est interdite sans l'autorisation écrite préalable de ZLO Technologies.</p>
          <p class="mt-4">Toute exploitation non autorisée du site ou de son contenu engage la responsabilité de l'utilisateur et constitue une contrefaçon sanctionnée par les articles L 335-2 et suivants du Code de la propriété intellectuelle.</p>
        `
      },
      {
        title: '5. Données personnelles',
        content: `
          <p>Les informations collectées sur ce site sont traitées conformément à notre Politique de confidentialité. Pour toute question relative aux données personnelles, vous pouvez nous contacter à : <a href="mailto:contact@zlotech.net" class="text-zlo-orange hover:underline">contact@zlotech.net</a></p>
        `
      },
      {
        title: '6. Cookies',
        content: `
          <p>Ce site utilise des cookies pour améliorer l'expérience utilisateur. En naviguant sur ce site, vous acceptez l'utilisation de cookies conformément à notre politique en la matière.</p>
        `
      },
      {
        title: '7. Liens hypertextes',
        content: `
          <p>Le site peut contenir des liens hypertextes vers d'autres sites. ZLO Technologies n'a pas la possibilité de vérifier le contenu des sites ainsi visités et n'assumera en conséquence aucune responsabilité de ce fait.</p>
        `
      },
      {
        title: '8. Limitation de responsabilité',
        content: `
          <p>ZLO Technologies s'efforce d'assurer l'exactitude et la mise à jour des informations diffusées sur ce site. Toutefois, ZLO Technologies ne peut garantir l'exactitude, la précision ou l'exhaustivité des informations mises à disposition sur ce site. En conséquence, ZLO Technologies décline toute responsabilité :</p>
          <ul class="list-disc ml-6 mt-2 space-y-1">
            <li>pour toute imprécision, inexactitude ou omission portant sur des informations disponibles sur le site</li>
            <li>pour tous dommages résultant d'une intrusion frauduleuse d'un tiers ayant entraîné une modification des informations mises à disposition sur le site</li>
            <li>et plus généralement pour tous dommages, directs ou indirects, qu'elles qu'en soient les causes, origines, nature ou conséquences</li>
          </ul>
        `
      },
      {
        title: '9. Droit applicable',
        content: `
          <p>Les présentes mentions légales sont soumises au droit togolais. En cas de litige, les tribunaux compétents seront ceux du ressort de Lomé, Togo.</p>
        `
      }
    ]
  } : {
    title: 'Legal Notice',
    lastUpdate: 'Last updated: February 2026',
    sections: [
      {
        title: '1. Site Publisher',
        content: `
          <p><strong>ZLO Technologies</strong></p>
          <p>IT Services and Engineering Company</p>
          <p>Headquarters: Lomé, Togo</p>
          <p>Email: contact@zlotech.net</p>
          <p>Phone: +228 90 XX XX XX</p>
        `
      },
      {
        title: '2. Publication Director',
        content: `
          <p><strong>G. Fambe O'Sodo</strong></p>
          <p>Managing Director - ZLO Technologies</p>
        `
      },
      {
        title: '3. Hosting',
        content: `
          <p>The site is hosted by:</p>
          <p><strong>Kimi Deploy</strong></p>
          <p>Cloud deployment service</p>
        `
      },
      {
        title: '4. Intellectual Property',
        content: `
          <p>All content on this site (texts, images, videos, logos, etc.) is the exclusive property of ZLO Technologies or its partners. Any reproduction, representation, modification, publication, transmission, distortion, total or partial, of the site or its content, by any means and on any medium is prohibited without the prior written authorization of ZLO Technologies.</p>
          <p class="mt-4">Any unauthorized exploitation of the site or its content engages the user's responsibility and constitutes infringement punishable by articles L 335-2 and following of the Intellectual Property Code.</p>
        `
      },
      {
        title: '5. Personal Data',
        content: `
          <p>Information collected on this site is processed in accordance with our Privacy Policy. For any questions regarding personal data, you can contact us at: <a href="mailto:contact@zlotech.net" class="text-zlo-orange hover:underline">contact@zlotech.net</a></p>
        `
      },
      {
        title: '6. Cookies',
        content: `
          <p>This site uses cookies to improve user experience. By browsing this site, you accept the use of cookies in accordance with our policy.</p>
        `
      },
      {
        title: '7. Hyperlinks',
        content: `
          <p>The site may contain hyperlinks to other sites. ZLO Technologies does not have the ability to verify the content of sites thus visited and therefore assumes no responsibility in this regard.</p>
        `
      },
      {
        title: '8. Limitation of Liability',
        content: `
          <p>ZLO Technologies strives to ensure the accuracy and updating of information published on this site. However, ZLO Technologies cannot guarantee the accuracy, precision or completeness of the information made available on this site. Consequently, ZLO Technologies declines all responsibility:</p>
          <ul class="list-disc ml-6 mt-2 space-y-1">
            <li>for any inaccuracy, inaccuracy or omission concerning information available on the site</li>
            <li>for any damage resulting from fraudulent intrusion by a third party resulting in modification of information made available on the site</li>
            <li>and more generally for all damages, direct or indirect, whatever their causes, origins, nature or consequences</li>
          </ul>
        `
      },
      {
        title: '9. Applicable Law',
        content: `
          <p>These legal notices are subject to Togolese law. In case of dispute, the competent courts will be those of Lomé, Togo.</p>
        `
      }
    ]
  };

  return (
    <div className="min-h-screen bg-zlo-dark">
      {/* Header */}
      <header className="bg-zlo-dark border-b border-white/10 py-6">
        <div className="w-full px-6 lg:px-12 flex items-center gap-4">
          <button
            onClick={goBack}
            className="flex items-center gap-2 text-white/60 hover:text-white transition-colors"
          >
            <ArrowLeft className="w-5 h-5" />
            <span>{i18n.language === 'fr' ? 'Retour' : 'Back'}</span>
          </button>
        </div>
      </header>

      {/* Content */}
      <main className="w-full px-6 lg:px-12 py-12 max-w-4xl mx-auto">
        <div className="flex items-center gap-4 mb-8">
          <div className="w-12 h-12 rounded-xl bg-zlo-red/20 flex items-center justify-center">
            <Scale className="w-6 h-6 text-zlo-red" />
          </div>
          <div>
            <h1 className="heading-lg text-white">{content.title}</h1>
            <p className="text-zlo-text-secondary text-sm">{content.lastUpdate}</p>
          </div>
        </div>

        <div className="space-y-8">
          {content.sections.map((section, index) => (
            <section key={index} className="bg-white/5 border border-white/10 rounded-xl p-6">
              <h2 className="font-sora font-semibold text-xl text-white mb-4">
                {section.title}
              </h2>
              <div 
                className="text-zlo-text-secondary leading-relaxed"
                dangerouslySetInnerHTML={{ __html: section.content }}
              />
            </section>
          ))}
        </div>

        {/* Footer */}
        <footer className="mt-12 pt-8 border-t border-white/10 text-center">
          <p className="text-zlo-text-secondary text-sm">
            © 2026 ZLO Technologies — {i18n.language === 'fr' ? 'Tous droits réservés' : 'All rights reserved'}
          </p>
        </footer>
      </main>
    </div>
  );
};

export default LegalPage;
