import { useEffect, useRef } from 'react';
import { useTranslation } from 'react-i18next';
import gsap from 'gsap';
import { ScrollTrigger } from 'gsap/ScrollTrigger';

gsap.registerPlugin(ScrollTrigger);

const Integration = () => {
  const { t } = useTranslation();
  const sectionRef = useRef<HTMLElement>(null);

  useEffect(() => {
    const section = sectionRef.current;
    if (!section) return;

    const ctx = gsap.context(() => {
      gsap.from('.int-pill', {
        scrollTrigger: {
          trigger: section,
          start: 'top 70%',
          toggleActions: 'play none none reverse',
        },
        x: -60,
        opacity: 0,
        duration: 0.8,
        stagger: 0.15,
        ease: 'power3.out',
      });

      gsap.from('.int-text', {
        scrollTrigger: {
          trigger: section,
          start: 'top 60%',
          toggleActions: 'play none none reverse',
        },
        x: 40,
        opacity: 0,
        duration: 0.8,
        stagger: 0.1,
        ease: 'power3.out',
      });
    }, section);

    return () => ctx.revert();
  }, []);

  return (
    <section
      ref={sectionRef}
      className="min-h-screen bg-zlo-dark grid-lines relative overflow-hidden py-24"
    >
      <div className="relative w-full px-6 lg:px-12">
        <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center min-h-[80vh]">
          {/* Left - Pills */}
          <div className="space-y-4">
            <div className="int-pill w-[90%] aspect-[16/10] pill-frame">
              <div className="relative w-full h-full">
                <img
                  src="/images/integration_support_desk.jpg"
                  alt="Support Desk"
                  className="w-full h-full object-cover img-treated"
                />
                <div className="absolute inset-0 bg-gradient-to-t from-zlo-dark/60 to-transparent" />
              </div>
            </div>
            <div className="int-pill w-full aspect-[16/9] pill-frame">
              <div className="relative w-full h-full">
                <img
                  src="/images/integration_server_closeup.jpg"
                  alt="Server Closeup"
                  className="w-full h-full object-cover img-treated"
                />
                <div className="absolute inset-0 bg-gradient-to-t from-zlo-dark/60 to-transparent" />
              </div>
            </div>
          </div>

          {/* Right - Text Block */}
          <div className="lg:pl-12">
            <h2 className="int-text heading-lg text-white mb-2">
              {t('integration.title1')}
            </h2>
            <h2 className="int-text heading-lg gradient-text mb-8">
              {t('integration.title2')}
            </h2>
            <div className="int-text gradient-line w-[60%] max-w-[300px] mb-8" />
            <p className="int-text body-text text-zlo-text-secondary mb-8 max-w-lg">
              {t('integration.body')}
            </p>
            <button className="int-text cta-button-outline">
              {t('integration.cta')}
            </button>
          </div>
        </div>
      </div>
    </section>
  );
};

export default Integration;