import { useEffect, useRef } from 'react';
import gsap from 'gsap';
import { ScrollTrigger } from 'gsap/ScrollTrigger';

gsap.registerPlugin(ScrollTrigger);

const teamMembers = [
  {
    role: 'Technical Lead',
    name: 'Agent 002',
    description: 'Architecte des solutions de demain, je supervise l\'intégration et la qualité des systèmes IT avec précision et expertise.',
    image: 'https://images.unsplash.com/photo-1507003211169-0a1dd7228f2d?w=400&q=80',
  },
  {
    role: 'Managing Director',
    name: 'G. Fambe O\'Sodo',
    description: 'Vision stratégique, sens du terrain et obsession de l\'impact concret. Je dirige ZLO Technologies comme une startup agile tournée vers l\'Afrique de demain.',
    image: 'https://images.unsplash.com/photo-1472099645785-5658abf4ff4e?w=400&q=80',
  },
  {
    role: 'Sales Manager',
    name: 'Agent 003',
    description: 'En tant qu\'ambassadeur de nos solutions, je développe des partenariats et anticipe les besoins du marché avec un sens aigu des relations clients.',
    image: 'https://images.unsplash.com/photo-1519085360753-af0119f7cbe7?w=400&q=80',
  },
];

export default function Team() {
  const sectionRef = useRef<HTMLDivElement>(null);

  useEffect(() => {
    const ctx = gsap.context(() => {
      gsap.fromTo(
        '.team-card',
        { y: 50, opacity: 0 },
        {
          y: 0,
          opacity: 1,
          duration: 0.6,
          stagger: 0.15,
          scrollTrigger: {
            trigger: '.team-grid',
            start: 'top 85%',
            toggleActions: 'play none none reverse',
          },
        }
      );
    }, sectionRef);

    return () => ctx.revert();
  }, []);

  return (
    <section ref={sectionRef} id="team" className="section-padding bg-[#0a0a0a] relative">
      <div className="container-custom">
        {/* Section Header */}
        <div className="mb-12">
          <span className="text-sm text-white/40 uppercase tracking-widest mb-4 block">
            La Team
          </span>
          <h2 className="text-3xl md:text-4xl lg:text-5xl font-bold text-white">
            NOTRE <span className="gradient-text">ÉQUIPE</span>
          </h2>
        </div>

        {/* Team Grid */}
        <div className="team-grid grid md:grid-cols-2 lg:grid-cols-3 gap-8">
          {teamMembers.map((member, index) => (
            <div
              key={index}
              className="team-card group"
            >
              {/* Image */}
              <div className="relative mb-6 overflow-hidden rounded-xl">
                <div className="aspect-[4/5] overflow-hidden">
                  <img
                    src={member.image}
                    alt={member.name}
                    className="w-full h-full object-cover grayscale group-hover:grayscale-0 transition-all duration-500 group-hover:scale-105"
                  />
                </div>
                {/* Overlay gradient */}
                <div className="absolute inset-0 bg-gradient-to-t from-[#0a0a0a]/80 via-transparent to-transparent" />
              </div>

              {/* Content */}
              <div>
                <span className="text-red-500 text-sm font-medium uppercase tracking-wider mb-2 block">
                  {member.role}
                </span>
                <h3 className="text-xl font-bold text-white mb-3">
                  {member.name}
                </h3>
                <p className="text-white/60 text-sm leading-relaxed">
                  {member.description}
                </p>
              </div>
            </div>
          ))}
        </div>
      </div>
    </section>
  );
}
